unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Dictionary;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ProgressBar1: TProgressBar;
    Button2: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    CheckBox1: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

uses ComObj;

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  SH: TDictionaryFounder;
  S: TStringList;
  M: TMemoryStream;
  I: Integer;
  Start: Cardinal;
begin
  S := TStringList.Create;
  try
    S.LoadFromFile('c:\1.txt');
    ProgressBar1.Position := 0;
    ProgressBar1.Max := S.Count;
    SH := TDictionaryFounder.Create;
    try
      Start := GetTickCount;
      for I := 0 to S.Count - 1 do
      begin
        SH.AddData(S.Strings[I]);
        ProgressBar1.Position := I;
      end;
      ShowMessage('  : ' + IntToStr(GetTickCount - Start));
      M := TMemoryStream.Create;
      try
        SH.SaveToStream(M);
        M.SaveToFile('c:\2.txt');
        ProgressBar1.Position := 0;
        Button2.Enabled := True;
      finally
        M.Free;
      end;
    finally
      SH.Free;
    end;
  finally
    S.Free;
  end;
end;


procedure TForm1.Button2Click(Sender: TObject);
var
  S: TDictionaryFinder;
  M: TMemoryStream;
begin
  S := TDictionaryFinder.Create;
  try
    M := TMemoryStream.Create;
    try
      M.LoadFromFile('c:\2.txt');        
      S.LoadFromStream(M);
      if S.Find(Edit1.Text, CheckBox1.Checked) then
        ShowMessage(' ')
      else
        ShowMessage('  ');
    finally
      M.Free;
    end;
  finally
    S.Free;
  end;
end;

end.
