////////////////////////////////////////////////////////////////////////////////
//
//  ****************************************************************************
//  * Project   : DomainInfo
//  * Unit Name : uMain
//  * Purpose   :        
//  * Author    :  (Rouse_) 
//  * Version   : 1.00
//  ****************************************************************************
//
//        " "   ...
//

unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls
  {$IFDEF VER150}
    , XPMan
  {$ENDIF};

const
  netapi32lib = 'netapi32.dll';
  NERR_Success = NO_ERROR;

type
  //       
  PWkstaInfo100 = ^TWkstaInfo100;
  TWkstaInfo100 = record
    wki100_platform_id  : DWORD;
    wki100_computername : PWideChar;
    wki100_langroup     : PWideChar;
    wki100_ver_major    : DWORD;
    wki100_ver_minor    : DWORD;
  end;

  //    DNS   
  TDomainControllerInfoA = record
    DomainControllerName: LPSTR;
    DomainControllerAddress: LPSTR;
    DomainControllerAddressType: ULONG;
    DomainGuid: TGUID;
    DomainName: LPSTR;
    DnsForestName: LPSTR;
    Flags: ULONG;
    DcSiteName: LPSTR;
    ClientSiteName: LPSTR;
  end;
  PDomainControllerInfoA = ^TDomainControllerInfoA;

  //    
  PNetDisplayUser = ^TNetDisplayUser;
  TNetDisplayUser = record
    usri1_name: LPWSTR;
    usri1_comment: LPWSTR;
    usri1_flags: DWORD;
    usri1_full_name: LPWSTR;
    usri1_user_id: DWORD;
    usri1_next_index: DWORD;
  end;

  //     
  PNetDisplayMachine = ^TNetDisplayMachine;
  TNetDisplayMachine = record
    usri2_name: LPWSTR;
    usri2_comment: LPWSTR;
    usri2_flags: DWORD;
    usri2_user_id: DWORD;
    usri2_next_index: DWORD;
  end;

  //    
  PNetDisplayGroup = ^TNetDisplayGroup;
  TNetDisplayGroup = record
    grpi3_name: LPWSTR;
    grpi3_comment: LPWSTR;
    grpi3_group_id: DWORD;
    grpi3_attributes: DWORD;
    grpi3_next_index: DWORD;
  end;

  //      
  //      
  PGroupUsersInfo0 = ^TGroupUsersInfo0;
  TGroupUsersInfo0 = record
    grui0_name: LPWSTR;
  end;

  TfrmDomainInfo = class(TForm)
    Button1: TButton;
    gbCurrent: TGroupBox;
    gbDomainResList: TGroupBox;
    ledCompName: TLabeledEdit;
    ledUserName: TLabeledEdit;
    ledDomainName: TLabeledEdit;
    ledControllerName: TLabeledEdit;
    lvUsers: TListView;
    gbInfo: TGroupBox;
    lbInfo: TListBox;
    VSplitter: TSplitter;
    pcRes: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    lvWorkStation: TListView;
    lvGroups: TListView;
    Label1: TLabel;
    memTrustedDomains: TMemo;
    ledDNSName: TLabeledEdit;
    procedure FormCreate(Sender: TObject);
    procedure lvGroupsClick(Sender: TObject);
  private
    CurrentDomainName: String;
    function GetCurrentUserName: String;
    function GetCurrentComputerName: String;
    function GetDomainController(const DomainName: String): String;
    function GetDNSDomainName(const DomainName: String): String;
    function EnumAllTrustedDomains: Boolean;
    function EnumAllUsers: Boolean;
    function EnumAllGroups: Boolean;
    function EnumAllWorkStation: Boolean;
    function GetSID(const SecureObject: String): String;
    function GetAllGroupUsers(const GroupName: String): Boolean;
    function GetAllUserGroups(const UserName: String): Boolean;
  end;

  //       
  function NetApiBufferFree(Buffer: Pointer): DWORD; stdcall;
    external netapi32lib;
  function NetWkstaGetInfo(ServerName: PWideChar; Level: DWORD;
    Bufptr: Pointer): DWORD; stdcall; external netapi32lib;
  function NetGetDCName(ServerName: PWideChar; DomainName: PWideChar;
    var Bufptr: PWideChar): DWORD; stdcall; external netapi32lib;
  function DsGetDcName(ComputerName, DomainName: PChar; DomainGuid: PGUID;
    SiteName: PChar; Flags: ULONG;
    var DomainControllerInfo: PDomainControllerInfoA): DWORD; stdcall;
    external netapi32lib name 'DsGetDcNameA';
  function NetQueryDisplayInformation(ServerName: PWideChar; Level: DWORD;
    Index: DWORD; EntriesRequested: DWORD; PreferredMaximumLength: DWORD;
    var ReturnedEntryCount: DWORD; SortedBuffer: Pointer): DWORD; stdcall;
    external netapi32lib;
  function NetGroupGetUsers(ServerName: PWideChar; GroupName: PWideChar; Level: DWORD;
    var Bufptr: Pointer; PrefMaxLen: DWORD; var EntriesRead: DWORD;
    var TotalEntries: DWORD; ResumeHandle: PDWORD): DWORD; stdcall;
    external netapi32lib;
  function NetUserGetGroups(ServerName: PWideChar; UserName: PWideChar; Level: DWORD;
    var Bufptr: Pointer; PrefMaxLen: DWORD; var EntriesRead: DWORD;
    var TotalEntries: DWORD): DWORD; stdcall; external netapi32lib;
  function NetEnumerateTrustedDomains(ServerName: PWideChar;
    DomainNames: PWideChar): DWORD; stdcall; external netapi32lib;
  procedure ConvertSidToStringSid(SID: PSID; var StringSid: LPSTR); stdcall;
    external advapi32 name 'ConvertSidToStringSidA';

var
  frmDomainInfo: TfrmDomainInfo;

implementation

{$R *.dfm}

//           
// =============================================================================
function TfrmDomainInfo.EnumAllGroups: Boolean;
var
  Tmp, Info: PNetDisplayGroup;
  I, CurrIndex, EntriesRequest,
  PreferredMaximumLength,
  ReturnedEntryCount: Cardinal;
  Error: DWORD;
begin
  CurrIndex := 0;
  repeat
    Info := nil;
    // NetQueryDisplayInformation     100- 
    //         ,
    //  ,      
    //  
    EntriesRequest := 100;
    PreferredMaximumLength := EntriesRequest * SizeOf(TNetDisplayGroup);
    ReturnedEntryCount := 0;
    //   ,     DNS   
    // (  IP ),      
    //        NetDisplayGroup
    //    3 ()   
    Error := NetQueryDisplayInformation(StringToOleStr(ledControllerName.Text), 3, CurrIndex,
      EntriesRequest, PreferredMaximumLength, ReturnedEntryCount, @Info);
    //       
    // 1. NERR_Success -   
    // 2. ERROR_MORE_DATA -  ,        
    if Error in [NERR_Success, ERROR_MORE_DATA] then
    try
      Tmp := Info;
      //       
      for I := 0 to ReturnedEntryCount - 1 do
      begin
        with lvGroups.Items.Add do
        begin
          Caption := Tmp^.grpi3_name;           //  
          SubItems.Add(Tmp^.grpi3_comment);     // 
          SubItems.Add(GetSID(Caption));        // SID 
          //         ( )
          CurrIndex := Tmp^.grpi3_next_index;
        end;
        Inc(Tmp);
      end;
    finally
      //    ,      
      NetApiBufferFree(Info);
    end;
  //     ERROR_MORE_DATA -   
  until Error in [NERR_Success, ERROR_ACCESS_DENIED];
  //         
  Result := Error = NERR_Success;
end;

//         
// =============================================================================
function TfrmDomainInfo.EnumAllTrustedDomains: Boolean;
var
  Tmp, DomainList: PWideChar;
begin
  //    NetEnumerateTrustedDomains
  // (  ,      ?)
  //    ,     ,   -   
  Result := NetEnumerateTrustedDomains(StringToOleStr(ledControllerName.Text),
    @DomainList) = NERR_Success;
  //    , ...
  if Result then
  try
    Tmp := DomainList;
    while Length(Tmp) > 0 do
    begin
      memTrustedDomains.Lines.Add(Tmp); //     
      Tmp := Tmp + Length(Tmp) + 1;
    end;
  finally
    //    
    NetApiBufferFree(DomainList);
  end;
end;

//           
// =============================================================================
function TfrmDomainInfo.EnumAllUsers: Boolean;
var
  Tmp, Info: PNetDisplayUser;
  I, CurrIndex, EntriesRequest,
  PreferredMaximumLength,
  ReturnedEntryCount: Cardinal;
  Error: DWORD;
begin
  CurrIndex := 0;
  repeat
    Info := nil;
    // NetQueryDisplayInformation     100- 
    //         ,
    //  ,      
    //  
    EntriesRequest := 100;
    PreferredMaximumLength := EntriesRequest * SizeOf(TNetDisplayUser);
    ReturnedEntryCount := 0;
    //   ,     DNS   
    // (  IP ),      
    //        NetDisplayUser
    //    1 ()   
    Error := NetQueryDisplayInformation(StringToOleStr(ledControllerName.Text), 1, CurrIndex,
      EntriesRequest, PreferredMaximumLength, ReturnedEntryCount, @Info);
    //       
    // 1. NERR_Success -   
    // 2. ERROR_MORE_DATA -  ,        
    if Error in [NERR_Success, ERROR_MORE_DATA] then
    try
      Tmp := Info;
      //       
      for I := 0 to ReturnedEntryCount - 1 do
      begin
        with lvUsers.Items.Add do
        begin
          Caption := Tmp^.usri1_name;          //  
          SubItems.Add(Tmp^.usri1_comment);    // 
          SubItems.Add(GetSID(Caption));       //  SID
          //         ( )
          CurrIndex := Tmp^.usri1_next_index;
        end;
        Inc(Tmp);
      end;
    finally
      //     NetQueryDisplayInformation 
      NetApiBufferFree(Info);
    end;
  //     ERROR_MORE_DATA
  // (..   ) -   
  until Error in [NERR_Success, ERROR_ACCESS_DENIED];
  //         
  Result := Error = NERR_Success;
end;

//            
//       ,       
//       ,    (     )
// =============================================================================
function TfrmDomainInfo.EnumAllWorkStation: Boolean;
var
  Tmp, Info: PNetDisplayMachine;
  I, CurrIndex, EntriesRequest,
  PreferredMaximumLength,
  ReturnedEntryCount: Cardinal;
  Error: DWORD;
begin
  CurrIndex := 0;
  repeat
    Info := nil;
    // NetQueryDisplayInformation     100- 
    //         ,
    //  ,      
    //  
    EntriesRequest := 100;
    PreferredMaximumLength := EntriesRequest * SizeOf(TNetDisplayMachine);
    ReturnedEntryCount := 0;
    //   ,     DNS   
    // (  IP ),      
    //         NetDisplayMachine
    //    2 ()   
    Error := NetQueryDisplayInformation(StringToOleStr(ledControllerName.Text), 2, CurrIndex,
      EntriesRequest, PreferredMaximumLength, ReturnedEntryCount, @Info);
    //       
    // 1. NERR_Success -   
    // 2. ERROR_MORE_DATA -  ,        
    if Error in [NERR_Success, ERROR_MORE_DATA] then
    try
      Tmp := Info;
      //       
      for I := 0 to ReturnedEntryCount - 1 do
      begin
        with lvWorkStation.Items.Add do
        begin
          Caption := Tmp^.usri2_name;          //   
          SubItems.Add(Tmp^.usri2_comment);    // 
          SubItems.Add(GetSID(Caption));       // Ÿ SID
          //         ( )
          CurrIndex := Tmp^.usri2_next_index;
        end;
        Inc(Tmp);
      end;
    finally
      //   
      NetApiBufferFree(Info);
    end;
  //     ERROR_MORE_DATA
  // (..   ) -   
  until Error in [NERR_Success, ERROR_ACCESS_DENIED];
  //         
  Result := Error = NERR_Success;
end;

procedure TfrmDomainInfo.FormCreate(Sender: TObject);
begin
  //      (     )
  ledUserName.Text := GetCurrentUserName;
  ledCompName.Text := GetCurrentComputerName;
  ledDomainName.Text := CurrentDomainName;
  ledControllerName.Text := GetDomainController(CurrentDomainName);
  // ,    ,    
  if ledControllerName.Text = '' then Exit;
  ledDNSName.Text := GetDNSDomainName(CurrentDomainName);
  EnumAllTrustedDomains;
  EnumAllUsers;
  EnumAllWorkStation;
  EnumAllGroups;
end;

//    ,      
// =============================================================================
function TfrmDomainInfo.GetAllGroupUsers(const GroupName: String): Boolean;
var
  Tmp, Info: PGroupUsersInfo0;
  PrefMaxLen, EntriesRead,
  TotalEntries, ResumeHandle: DWORD;
  I: Integer;
begin
  //        
  lbInfo.Items.Clear;
  //  
  ResumeHandle := 0;
  PrefMaxLen := DWORD(-1);
  // 
  Result := NetGroupGetUsers(StringToOleStr(ledControllerName.Text),
    StringToOleStr(GroupName), 0, Pointer(Info), PrefMaxLen,
    EntriesRead, TotalEntries, @ResumeHandle) = NERR_Success;
  //  ...
  if Result then
  try
    Tmp := Info;
    for I := 0 to EntriesRead - 1 do
    begin
      lbInfo.Items.Add(Tmp^.grui0_name); //     
      Inc(Tmp);
    end;
  finally
    //  ,     :)
    NetApiBufferFree(Info);
  end;
end;

//     ( -  )
// =============================================================================
function TfrmDomainInfo.GetAllUserGroups(const UserName: String): Boolean;
var
  Tmp, Info: PGroupUsersInfo0;
  PrefMaxLen, EntriesRead,
  TotalEntries: DWORD;
  I: Integer;
begin
  lbInfo.Items.Clear;
  PrefMaxLen := DWORD(-1);
  Result := NetUserGetGroups(StringToOleStr(ledControllerName.Text),
    StringToOleStr(UserName), 0, Pointer(Info), PrefMaxLen,
    EntriesRead, TotalEntries) = NERR_Success;
  if Result then
  try
    Tmp := Info;
    for I := 0 to EntriesRead - 1 do
    begin
      lbInfo.Items.Add(Tmp^.grui0_name);
      Inc(Tmp);
    end;
  finally
    NetApiBufferFree(Info);
  end;
end;

//       
// =============================================================================
function TfrmDomainInfo.GetCurrentComputerName: String;
var
  Info: PWkstaInfo100;
  Error: DWORD;
begin
  //       
  Error := NetWkstaGetInfo(nil, 100, @Info);
  if Error <> 0 then
    raise Exception.Create(SysErrorMessage(Error));
  //  ,     ,    ,    :)

  //      
  Result := Info^.wki100_computername;
  //    
  CurrentDomainName := info^.wki100_langroup;
end;

//   
// =============================================================================
function TfrmDomainInfo.GetCurrentUserName: String;
var
  Size: Cardinal;
begin
  Size := MAXCHAR;
  SetLength(Result, Size);
  GetUserName(PChar(Result), Size);
  SetLength(Result, Size);
end;

//   DNS   
// =============================================================================
function TfrmDomainInfo.GetDNSDomainName(const DomainName: String): String;
const
  DS_IS_FLAT_NAME = $00010000;
  DS_RETURN_DNS_NAME  = $40000000;
var
  GUID: PGUID;
  DomainControllerInfo: PDomainControllerInfoA;
begin
  GUID := nil;
  //      IP   
  //   DNS ,     :
  if DsGetDcName(nil, PChar(CurrentDomainName), GUID, nil,
    DS_IS_FLAT_NAME or DS_RETURN_DNS_NAME, DomainControllerInfo) = NERR_Success then
  //     :
  // DS_IS_FLAT_NAME -    
  // DS_RETURN_DNS_NAME -   DNS 
  try
    Result := DomainControllerInfo^.DomainControllerName; //   ...
  finally
    //   ,   ...
    NetApiBufferFree(DomainControllerInfo);
  end;
end;

//      -     
// =============================================================================
function TfrmDomainInfo.GetDomainController(const DomainName: String): String;
var
  Domain: WideString;
  Server: PWideChar;
begin
  Domain := StringToOleStr(DomainName);
  if NetGetDCName(nil, @Domain[1], Server) = NERR_Success then
  try
    Result := Server;
  finally
    NetApiBufferFree(Server);
  end;
end;

//      ,    -  SID 
//   ...
// =============================================================================
function TfrmDomainInfo.GetSID(const SecureObject: String): String;
var
  SID: PSID;
  StringSid: PChar;
  ReferencedDomain: String;
  cbSid, cbReferencedDomain:DWORD;
  peUse: SID_NAME_USE;
begin
  cbSID := 128;
  cbReferencedDomain := 16;
  GetMem(SID, cbSid);
  try
    SetLength(ReferencedDomain, cbReferencedDomain);
    if LookupAccountName(PChar(ledDNSName.Text),
      PChar(SecureObject), SID, cbSid,
      @ReferencedDomain[1], cbReferencedDomain, peUse) then
    begin
      ConvertSidToStringSid(SID, StringSid);
      Result := StringSid;
    end;
  finally
    FreeMem(SID);
  end;
end;

procedure TfrmDomainInfo.lvGroupsClick(Sender: TObject);
var
  Value: String;
begin
  if (Sender as TListView).Selected = nil then Exit;
  Value := (Sender as TListView).Selected.Caption;
  case (Sender as TListView).Tag of
    0:
    begin
      gbInfo.Caption := Format('     "%s"', [Value]);
      GetAllUserGroups(Value);
    end;
    1:
    begin
      gbInfo.Caption := Format('      "%s"', [Value]);
      GetAllUserGroups(Value);
    end;
    2:
    begin
      gbInfo.Caption := Format('    "%s"', [Value]);
      GetAllGroupUsers(Value);
    end;
  end;
end;

end.
