unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WinSock, StdCtrls, ExtCtrls, Spin, Menus, ShellAPI;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Panel1: TPanel;
    btnConnect: TButton;
    cbMailes: TComboBox;
    btnTop: TButton;
    edPOPServer: TEdit;
    Label1: TLabel;
    edLogin: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    edPassword: TEdit;
    btnLogin: TButton;
    btnMail: TButton;
    btnLogOut: TButton;
    btnList: TButton;
    Label4: TLabel;
    btnDelete: TButton;
    Label5: TLabel;
    GroupBox1: TGroupBox;
    rbKOI: TRadioButton;
    rbWin: TRadioButton;
    btnClear: TButton;
    seLines: TSpinEdit;
    cbAll: TCheckBox;
    Label6: TLabel;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    SaveDialog1: TSaveDialog;
    N5: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    OpenDialog1: TOpenDialog;
    N8: TMenuItem;
    N9: TMenuItem;
    RFC1: TMenuItem;
    procedure btnConnectClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnTopClick(Sender: TObject);
    procedure btnLoginClick(Sender: TObject);
    procedure btnListClick(Sender: TObject);
    procedure btnLogOutClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnMailClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure N4Click(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure N5Click(Sender: TObject);
    procedure N6Click(Sender: TObject);
    procedure RFC1Click(Sender: TObject);
    procedure N9Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
implementation

uses SOCKET_MISK, RussianCodeTables;

{$R *.DFM}
procedure TForm1.btnConnectClick(Sender: TObject);
begin
cbMailes.Items.Clear;
Memo1.Lines.Add('  ...');
If Not Init_Socket Then
Begin
Memo1.Lines.Add('!    !');
Exit;
End;
Memo1.Lines.Add('K!   !');
Application.ProcessMessages;

Memo1.Lines.Add(' ...');
If Not Make_Socket Then
Begin
Memo1.Lines.Add('!   !');
Exit;
End;
Memo1.Lines.Add('K!  !');
Application.ProcessMessages;

Memo1.Lines.Add(' POP3-...');
If Not Find_POPHost(edPOPServer.Text) Then
Begin
Memo1.Lines.Add('! POP3- "'+edPOPServer.Text+'"  !');
Exit;
End;
Memo1.Lines.Add('! POP3- !');
Application.ProcessMessages;


Memo1.Lines.Add(' POP3-...');
If Not Connect_POPHost Then
Begin
Memo1.Lines.Add('!    POP3-!');
Exit;
End;
Memo1.Lines.Add('K! POP3-  !');
Application.ProcessMessages;

Memo1.Lines.Add('POP3- :');
Response_Host(True, Memo1.Lines, csNone);
Application.ProcessMessages;

Memo1.Lines.Add('.');
btnLogin.Enabled:=True;
btnLogOut.Enabled:=True;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
hSocket:=INVALID_SOCKET;
end;

procedure TForm1.btnTopClick(Sender: TObject);
Var
S:String;
CharSet:TCharset;
N:Integer;
begin
If rbKOI.Checked Then CharSet:=csKOI
Else
CharSet:=csNone;

For N:=0 To cbMailes.Items.Count -1 Do
Begin
Memo1.Lines.Add('');
If cbAll.Checked Then
cbMailes.ItemIndex:=N;
S:='Top '+cbMailes.Text+' '+IntToStr(seLines.Value);
Memo1.Lines.Add(' :');
Memo1.Lines.Add(S);
S:=S+#13#10;
write_s(hSocket,S);
Memo1.Lines.Add('POP3- :');
If Response_Host(False,Memo1.Lines,CharSet) < 0 Then
Begin
S:='!     !';
Memo1.Lines.Add(S);
Exit;
End;
S:='.';
Memo1.Lines.Add(S);
If Not cbAll.Checked Then Break;
End;

end;

procedure TForm1.btnLoginClick(Sender: TObject);
Var
S:String;
begin
Memo1.Lines.Add('');
Memo1.Lines.Add(' :');
S:='USER '+edLogin.Text;
Memo1.Lines.Add(S);
S:=S+#13#10;
write_s(hSocket,S);
Application.ProcessMessages;

Memo1.Lines.Add('POP3- :');
If Response_Host(True,Memo1.Lines,csNone)<0 Then
Begin
Memo1.Lines.Add('!  !');
Exit;
End;
Memo1.Lines.Add('.');
Application.ProcessMessages;

Memo1.Lines.Add('');
S:='PASS '+edPassword.Text;
Memo1.Lines.Add(' :');
Memo1.Lines.Add(S);
S:=S+#13#10;
write_s(hSocket,S);
Memo1.Lines.Add('POP3- :');
Application.ProcessMessages;

If Response_Host(True,Memo1.Lines,csNone) < 0 Then
Begin
Memo1.Lines.Add('! !');
Exit;
End;
Memo1.Lines.Add('.');
Memo1.Lines.Add('');
btnList.Enabled:=True;
cbMailes.Enabled:=True;
end;

procedure TForm1.btnListClick(Sender: TObject);
Var
S:String;
N,M:Integer;
begin
cbMailes.Clear;
S:='LIST';
Memo1.Lines.Add(' :');
Memo1.Lines.Add(S);
S:=S+#13#10;
write_s(hSocket,S);
Memo1.Lines.Add('POP3- :');

N:=Response_Host(False,Memo1.Lines,csNone);
If N < 0 Then
Begin
S:='!     !';
Memo1.Lines.Add(S);
Exit;
End;
Memo1.Lines.Add('.');

cbMailes.Enabled:=(N>1);
For M:=1 To N-1 Do
cbMailes.Items.Add(IntToStr(M));

If cbMailes.Enabled Then
cbMailes.ItemIndex:=0;
btnTop.Enabled:=cbMailes.Enabled;
btnMail.Enabled:=cbMailes.Enabled;
btnDelete.Enabled:=cbMailes.Enabled;
seLines.Enabled:=cbMailes.Enabled;
end;

procedure TForm1.btnLogOutClick(Sender: TObject);
Var
S:String;
begin
S:='QUIT';
Memo1.Lines.Add(' :');
Memo1.Lines.Add(S);
S:=S+#13#10;
write_s(hSocket,S);
Memo1.Lines.Add('POP3- :');
If Response_Host(True,Memo1.Lines,csNone)<0 Then
Begin
Memo1.Lines.Add('!    !');
Exit;
End;


btnLogin.Enabled:=False;
btnLogOut.Enabled:=False;
btnList.Enabled:=False;
btnTop.Enabled:=False;
btnMail.Enabled:=False;
btnDelete.Enabled:=False;
cbMailes.Enabled:=False;
seLines.Enabled:=False;

Close_Socket;
Memo1.Lines.Add(' .');
Memo1.Lines.Add(' .');

end;

procedure TForm1.btnDeleteClick(Sender: TObject);
Var
S:String;
N:Integer;
begin
For N:=0 To cbMailes.Items.Count-1 Do
Begin
Memo1.Lines.Add('');
If cbAll.Checked Then
cbMailes.ItemIndex:=N;
S:='DELE '+cbMailes.Text;
Memo1.Lines.Add(' :');
Memo1.Lines.Add(S);
S:=S+#13#10;
write_s(hSocket,S);
Memo1.Lines.Add('POP3- :');
If Response_Host(True,Memo1.Lines,csNone)<0 Then
Begin
Memo1.Lines.Add('!   !');
Exit;
End;
If Not cbAll.Checked Then Break;
End;
Memo1.Lines.Add('.');


end;

procedure TForm1.btnMailClick(Sender: TObject);
Var
S:String;
CharSet:TCharset;
N:Integer;
begin
If rbKOI.Checked Then
CharSet:=csKOI
Else
CharSet:=csNone;

For N:=0 To cbMailes.Items.Count-1 Do
Begin
Memo1.Lines.Add('');
S:='RETR '+cbMailes.Text;
Memo1.Lines.Add(' :');
Memo1.Lines.Add(S);
S:=S+#13#10;
write_s(hSocket,S);
Memo1.Lines.Add('POP3- :');
If cbAll.Checked Then
cbMailes.ItemIndex:=N;
If Response_Host(False,Memo1.Lines,CharSet)<0 Then
Begin
S:='!    !';
Memo1.Lines.Add(S);
Exit;
End;
If Not cbAll.Checked Then Break;
End;
Memo1.Lines.Add('.');
end;

procedure TForm1.btnClearClick(Sender: TObject);
begin
Memo1.Lines.Clear;
end;

procedure TForm1.N4Click(Sender: TObject);
begin
Close;
end;

procedure TForm1.N2Click(Sender: TObject);
Var
FileName:String;
Ext:String;
begin
SaveDialog1.Filter:='|*.txt||*.eml||*.*';
If Not SaveDialog1.Execute Then Exit;
FileName:=SaveDialog1.FileName;
Case SaveDialog1.FilterIndex Of
1:Ext:='.txt';
2:Ext:='.eml';
3:Ext:='';
End;
If Not(ExtractFileExt(FileName)=Ext) Then
FileName:=FileName+Ext;
Memo1.Lines.SaveToFile(FileName);
end;

procedure TForm1.N5Click(Sender: TObject);
Var
FileName:String;
Ext:String;
Sel:TStrings;
begin
SaveDialog1.Filter:='|*.eml||*.*';
If Not SaveDialog1.Execute Then Exit;
FileName:=SaveDialog1.FileName;
Case SaveDialog1.FilterIndex Of
1:Ext:='.eml';
2:Ext:='';
End;
If Not(ExtractFileExt(FileName)=Ext) Then
FileName:=FileName+Ext;
Sel:=TStringList.Create;;
Sel.Add(Memo1.SelText);
Sel.SaveToFile(FileName);
Sel.Free;
end;

procedure TForm1.N6Click(Sender: TObject);
begin
If Not OpenDialog1.Execute Then Exit;
Memo1.Lines.Clear;
Memo1.Lines.LoadFromFile(OpenDialog1.FileName);
end;

procedure TForm1.RFC1Click(Sender: TObject);
Var
FileName:String;
begin
FileName:=ExtractFilePath(ParamStr(0))+'rfc 1939.txt';
ShellExecute(Handle,'open',PChar(FileName),Nil,Nil,SW_SHOWMAXIMIZED);
end;

procedure TForm1.N9Click(Sender: TObject);
Var
FileName:String;
begin
FileName:=ExtractFilePath(ParamStr(0))+'HowWork.html';
ShellExecute(Handle,'open',PChar(FileName),Nil,Nil,SW_SHOWNORMAL);
end;

end.
