unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Socket_Misk, ExtCtrls, Menus;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    memoLog: TMemo;
    Panel1: TPanel;
    Label2: TLabel;
    edFrom: TEdit;
    Label1: TLabel;
    memoRecipients: TMemo;
    Label3: TLabel;
    edSubject: TEdit;
    Label4: TLabel;
    memoBody: TMemo;
    Label5: TLabel;
    edSMTPHost: TEdit;
    GroupBox1: TGroupBox;
    lbLogin: TLabel;
    lbPassword: TLabel;
    edLogin: TEdit;
    edPassword: TEdit;
    cbAuth: TCheckBox;
    btnMail: TButton;
    btnClose: TButton;
    Splitter1: TSplitter;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    procedure btnMailClick(Sender: TObject);
    procedure cbAuthClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure N4Click(Sender: TObject);
  private
    { Private declarations }
  //  SMTP-
  Procedure WMSMTP(var Msg:TMessage); message WM_SMTP;
  //  SMTP-
  Function ProcessSMTPResult(ReceivedResult,// 
                            ExpectResult:Integer;// 
                            CloseSMTPSession:Boolean)//   
                            :Boolean;
  //    SMTP-
  Function ProcessSMTPWrite(SMTPWriting:Boolean):Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Base64Unit;

{$R *.DFM}
Procedure TForm1.WMSMTP(var Msg:TMessage);
Var
CS:String;
Begin {WMSMTP}
CS:='';
Case Msg.WParam Of
0:CS:='C:>';
1:CS:='S:>';
End;
memoLog.Text:=memoLog.Text+CS+String(Msg.lParam);
Application.ProcessMessages;
inherited;
End;  {WMSMTP}

Function TForm1.ProcessSMTPWrite(SMTPWriting:Boolean):Boolean;
Begin
If SMTPWriting Then
Begin
Result:=True;
StatusBar1.Panels[0].Text:=' ...';
End
Else
Begin
Result:=False;
StatusBar1.Panels[0].Text:='  ...';
End;
Application.ProcessMessages;
End;

Function TForm1.ProcessSMTPResult(ReceivedResult,ExpectResult:Integer;
                                  CloseSMTPSession:Boolean):Boolean;
Begin
If ReceivedResult=0 Then
Begin {   }
// ,        
//   ReadFromSocket  Socket_Misk.pas
StatusBar1.Panels[0].Text:='   ...';
Result:=False;
End   {   }
Else
Begin {  }
//    
If Not(ReceivedResult=ExpectResult) Then
Begin {If Not}
If CloseSMTPSession Then
//  -      
Begin {CloseSMTPSession}
//    SMTP-
If WriteToSocket('QUIT') Then
ReadFromSocket;
CleanUp;
StatusBar1.Panels[0].Text:=' SMTP-...';
End  {CloseSMTPSession}
Else
Begin {Else CloseSMTPSession}
//  -   ,    
StatusBar1.Panels[0].Text:='   ...';
End;{Else CloseSMTPSession}
Result:=False;
End {If Not}
Else
Begin { }
//   -  
StatusBar1.Panels[0].Text:='...';
Result:=True;
End;  { }
End; {  }
Application.ProcessMessages;
End;

procedure TForm1.btnMailClick(Sender: TObject);
Var
N:Integer;
begin
If edSMTPHost.Text='' Then
Begin
MessageBox(Handle,'SMTP-   !','!',MB_OK Or MB_ICONERROR);
edSMTPHost.SetFocus;
Exit;
End;

If edFrom.Text='' Then
Begin
MessageBox(Handle,' FROM:  !','!',MB_OK Or MB_ICONERROR);
edFrom.SetFocus;
Exit;
End;

If memoRecipients.Text='' Then
Begin
MessageBox(Handle,' TO:  !','!',MB_OK Or MB_ICONERROR);
memoRecipients.SetFocus;
Exit;
End;

memoLog.Lines.Clear;
StatusBar1.Panels[0].Text:=' ...';
If Not InitSocket Then
Begin
StatusBar1.Panels[0].Text:='  ...';
Application.ProcessMessages;
Exit;
End;
//=================================Connect&OPEN=================================
//
StatusBar1.Panels[0].Text:='  ...';
{SMTP port = 25}
If Not ConnectHost(25,edSMTPHost.Text) Then
Begin
StatusBar1.Panels[0].Text:='   ...';
Application.ProcessMessages;
Exit;
End;
StatusBar1.Panels[0].Text:='...';
//  220 - OK RFC 821
StatusBar1.Panels[0].Text:='   ...';
If Not ProcessSMTPResult(SocketResult(ReadFromSocket),220,True) Then
Exit;

//=================================EHLO=========================================
// EHLO  SMTP Service Extension - ESMTP
//RFC 1854, 2197
//    (pipelining) ESMTP 
//SMTP (RFC 821)   ,     -  
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket('EHLO SMTPSample')) Then
//If Not ProcessSMTPWrite(WriteToSocket('HELO SMTPSample')) Then
Exit;

// 250 RFC 1854,   (pipelining)  ,
//   
StatusBar1.Panels[0].Text:='   ...';
If Not ProcessSMTPResult(SocketResult(ReadFromSocket),250,True) Then
Exit;

//  SMTP- 
If cbAuth.Checked Then
Begin {cbAuth.Checked Login}
//===============================AUTH LOGIN=====================================
// SMTP-  AUTH LOGIN,
//RFC 2554
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket('AUTH LOGIN')) Then
Exit;

//   334 (RFC 2554)  base64   VXNlcm5hbWU6 (User:),
//    (. )   ,
//( CloseSMTPSession  ProcessSMTPResult  False)
//.. ,         
//,   LOGIN PLAIN
StatusBar1.Panels[0].Text:='   ...';
If Not ProcessSMTPResult(SocketResult(ReadFromSocket),334,False) Then
//  (RFC 2554)  
//432 A password transition is needed
//454 Temporary authentication failure
//501 Server cannot BASE64 decode the argument
//503 Any further AUTH commands after a successful AUTH command completes
//504 Requested authentication mechanism is not supported
//530 Authentication required
//534 Authentication mechanism is too weak
//535 Authorization failed
//538 Encryption required for requested authentication mechanism
//553 Authorization failed or you have have reached maximum messages in a hour (flock1.newmail.ru ESMTP)

// 
cbAuth.Checked:=False;
End;{cbAuth.Checked Login}
//       334

//=================================User=========================================
//  SMTP- 
If cbAuth.Checked Then
Begin {cbAuth.Checked User}
StatusBar1.Panels[0].Text:='    ...';
// base64- Login
If Not ProcessSMTPWrite(WriteToSocket(StrToStrBase64(edLogin.Text))) Then
Exit;

StatusBar1.Panels[0].Text:='   ...';
//   334 (RFC 2554)  base64-  UGFzc3dvcmQ6 (Password:)
If Not ProcessSMTPResult(SocketResult(ReadFromSocket),334,False) Then
//      
cbAuth.Checked:=False;
End;  {cbAuth.Checked User}
//================================Password======================================
//  SMTP- 
If cbAuth.Checked Then
Begin {cbAuth.Checked Password}
StatusBar1.Panels[0].Text:='    ...';
// base64- Password
If Not ProcessSMTPWrite(WriteToSocket(StrToStrBase64(edPassword.Text))) Then
Exit;

StatusBar1.Panels[0].Text:='   ...';
//   235,
If Not ProcessSMTPResult(SocketResult(ReadFromSocket),235,True) Then
//      ,
//    , -  SMTP-
//( CloseSMTPSession  ProcessSMTPResult  True)
Exit;
End;  {cbAuth.Checked Password}

//=================================MAIL FROM:===================================
//  MAIL FROM: (RFC 821)
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket('MAIL FROM: <'+edFrom.Text+'>')) Then
Exit;

//   250 (RFC 821),
StatusBar1.Panels[0].Text:='   ...';
If Not ProcessSMTPResult(SocketResult(ReadFromSocket),250,True) Then
Exit;

//===================================RCPT TO:===================================
//  RCPT TO: (RFC 821)
For N:=0 To memoRecipients.Lines.Count-1 Do
Begin {For N}
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket('RCPT TO: <'+memoRecipients.Lines.Strings[N]+'>'))
Then
Exit;

StatusBar1.Panels[0].Text:='   ...';
If Not ProcessSMTPResult(SocketResult(ReadFromSocket),250,True) Then
Exit;

End;  {For N}
(*
//   250 (RFC 821),
StatusBar1.Panels[0].Text:='   ...';
If Not ProcessSMTPResult(SocketResult(ReadFromSocket),250,True) Then
Exit;
*)

//===================================DATA=======================================
//  DATA (RFC 821)
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket('DATA')) Then
Exit;

//   354 (RFC 821),
StatusBar1.Panels[0].Text:='   ...';
If Not ProcessSMTPResult(SocketResult(ReadFromSocket),354,True) Then
Exit;
//   (  +  )
// RFC (822) From: ( )
StatusBar1.Panels[0].Text:='    ...';
If Not WriteToSocket('From: '+edFrom.Text) Then
Begin
StatusBar1.Panels[0].Text:='  ...';
Application.ProcessMessages;
Exit;
End;
StatusBar1.Panels[0].Text:=' ...';

// RFC (822) Date:  ( )
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket('Date: '+InternetDate)) Then
Exit;

// RFC (822) To:  ( )
For N:=0 To memoRecipients.Lines.Count-1 Do
Begin {For N}
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket('To: <'+memoRecipients.Lines.Strings[N]+'>')) Then
Exit;
End;  {For N}

// RFC (822) Subject:  (  )
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket('Subject: '+edSubject.Text)) Then
Exit;

// RFC (822) Content-Type:  (  )
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket('Content-Type: text/plain; charset=windows-1251')) Then
Exit;

//       
//(  RFC 821)
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket('')) Then
Exit;
//  (RFC 821)
For N:=0 To memoBody.Lines.Count-1 Do
Begin {For N}
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket(memoBody.Lines.Strings[N])) Then
Exit;
End;  {For N}
//   
//(  RFC 821)
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket('.')) Then
Exit;

//   250 (RFC 821),
StatusBar1.Panels[0].Text:='   ...';
If Not ProcessSMTPResult(SocketResult(ReadFromSocket),250,True) Then
Exit;

//======================================QUIT====================================
//  QUIT (RFC 821)
StatusBar1.Panels[0].Text:='    ...';
If Not ProcessSMTPWrite(WriteToSocket('QUIT')) Then
Exit;

//   221 (RFC 821),
StatusBar1.Panels[0].Text:='   ...';
If Not ProcessSMTPResult(SocketResult(ReadFromSocket),221,True) Then
Exit;

ShowMessage('OK!');

end;

procedure TForm1.cbAuthClick(Sender: TObject);
begin
lbLogin.Enabled:=cbAuth.Checked;
lbPassword.Enabled:=cbAuth.Checked;
edLogin.Enabled:=cbAuth.Checked;
edPassword.Enabled:=cbAuth.Checked;
end;

procedure TForm1.btnCloseClick(Sender: TObject);
begin
Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
MainFormHandle:=Handle;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
//Cleanup;
end;

procedure TForm1.N4Click(Sender: TObject);
begin
If Not SaveDialog1.Execute Then Exit;
memoLog.Lines.SaveToFile(SaveDialog1.FileName);
end;

end.
